/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.PacketHandlerPlayer;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.blocks.CustomBlock;
import noppes.npcs.blocks.CustomBlockPortal;
import noppes.npcs.blocks.CustomBlockSlab;
import noppes.npcs.blocks.CustomBlockStairs;
import noppes.npcs.blocks.CustomChest;
import noppes.npcs.blocks.CustomDoor;
import noppes.npcs.blocks.CustomLiquid;
import noppes.npcs.blocks.tiles.CustomTileEntityChest;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.containers.ContainerAvailabilityInv;
import noppes.npcs.containers.ContainerBuilderSettings;
import noppes.npcs.containers.ContainerCarpentryBench;
import noppes.npcs.containers.ContainerCustomChest;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerDead;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.containers.ContainerMerchantAdd;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.containers.ContainerNPCCompanion;
import noppes.npcs.containers.ContainerNPCDropSetup;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.containers.ContainerNPCFollowerSetup;
import noppes.npcs.containers.ContainerNPCInv;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.containers.ContainerNPCTraderSetup;
import noppes.npcs.containers.ContainerNPCTransportSetup;
import noppes.npcs.containers.ContainerNpcItemGiver;
import noppes.npcs.containers.ContainerNpcQuestReward;
import noppes.npcs.containers.ContainerNpcQuestRewardItem;
import noppes.npcs.containers.ContainerNpcQuestTypeItem;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.CustomArmor;
import noppes.npcs.items.CustomBow;
import noppes.npcs.items.CustomFishingRod;
import noppes.npcs.items.CustomShield;
import noppes.npcs.items.CustomTool;
import noppes.npcs.items.CustomWeapon;
import noppes.npcs.reflection.entity.player.EntityPlayerMPReflection;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;

public class CommonProxy
implements IGuiHandler {
    public static final Map<String, TempFile> downloadableFiles = new HashMap<String, TempFile>();
    public static final Map<EntityPlayer, Availability> availabilityStacks = new HashMap<EntityPlayer, Availability>();
    public boolean newVersionAvailable = false;
    public int revision = 4;

    public void checkBlockFiles(ICustomElement customblock) {
        File itemModel;
        File blockstate;
        File chest;
        String name = customblock.getCustomName().toLowerCase();
        String fileName = Objects.requireNonNull(((Block)customblock).getRegistryName()).func_110623_a().toLowerCase();
        File blockstatesDir = new File(CustomNpcs.Dir, "assets/customnpcs/blockstates");
        File blockModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/block");
        File itemModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/item");
        if (!blockstatesDir.exists() && !blockstatesDir.mkdirs()) {
            return;
        }
        if (!blockModelsDir.exists() && !blockModelsDir.mkdirs()) {
            return;
        }
        if (!itemModelsDir.exists() && !itemModelsDir.mkdirs()) {
            return;
        }
        String crEnt = "\n";
        String crTab = "\t";
        File orientable = new File(blockModelsDir, "orientable.json");
        if (!orientable.exists() && Util.instance.saveFile(orientable, Util.instance.getDataFile("ort.dat"))) {
            LogWriter.debug("Create Orientable Block Model for \"orientable\" block");
        }
        if (!(chest = new File(blockModelsDir, "chest.json")).exists() && Util.instance.saveFile(chest, Util.instance.getDataFile("jch.dat"))) {
            LogWriter.debug("Create Chest Block Model for \"custom chest\" block");
        }
        if (!(blockstate = new File(blockstatesDir, fileName.toLowerCase() + ".json")).exists()) {
            String jsonState = null;
            if (customblock instanceof CustomLiquid) {
                jsonState = Util.instance.getDataFile("jlq.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            } else if (customblock instanceof CustomBlockStairs) {
                jsonState = Util.instance.getDataFile("jbs.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            } else if (customblock instanceof CustomBlockSlab) {
                jsonState = customblock instanceof CustomBlockSlab.CustomBlockSlabSingle ? Util.instance.getDataFile("jss.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName) : Util.instance.getDataFile("jsd.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            } else if (customblock instanceof CustomBlockPortal) {
                jsonState = Util.instance.getDataFile("jbp.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            } else if (customblock instanceof CustomBlock && ((CustomBlock)customblock).hasProperty()) {
                int i;
                NBTTagCompound data = ((CustomBlock)customblock).nbtData.func_74775_l("Property");
                jsonState = Util.instance.getDataFile("jpr.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                StringBuilder variants = new StringBuilder();
                if (data.func_74771_c("Type") == 1) {
                    variants.append(crTab).append(crTab).append("\"").append(data.func_74779_i("Name")).append("=true\": { \"model\": \"").append("customnpcs").append(":").append(fileName.toLowerCase()).append("_true\" },").append(crEnt);
                    variants.append(crTab).append(crTab).append("\"").append(data.func_74779_i("Name")).append("=false\": { \"model\": \"").append("customnpcs").append(":").append(fileName.toLowerCase()).append("_false\" }");
                    jsonState = jsonState.replace("{type}", "Byte").replace("{variants}", variants.toString());
                } else if (data.func_74771_c("Type") == 3) {
                    for (i = data.func_74762_e("Min"); i <= data.func_74762_e("Max"); ++i) {
                        variants.append(crTab).append(crTab).append("\"").append(data.func_74779_i("Name")).append("=").append(i).append("\": { \"model\": \"").append("customnpcs").append(":").append(fileName.toLowerCase()).append("_").append(i).append("\" }");
                        if (i >= data.func_74762_e("Max") - 1) continue;
                        variants.append(",").append(crEnt);
                    }
                    jsonState = jsonState.replace("{type}", "Integer").replace("{variants}", variants.toString());
                } else if (data.func_74771_c("Type") == 4) {
                    i = 0;
                    for (EnumFacing ef : EnumFacing.field_82609_l) {
                        if (ef == EnumFacing.DOWN || ef == EnumFacing.UP) continue;
                        variants.append(crTab).append(crTab).append("\"").append(data.func_74779_i("Name")).append("=").append(ef.func_176742_j()).append("\": { \"model\": \"").append("customnpcs").append(":").append(fileName.toLowerCase()).append("\"");
                        if (ef == EnumFacing.SOUTH) {
                            variants.append(", \"y\": 180");
                        } else if (ef == EnumFacing.WEST) {
                            variants.append(", \"y\": 270");
                        } else if (ef == EnumFacing.EAST) {
                            variants.append(", \"y\": 90");
                        }
                        variants.append(" }");
                        if (i < 3) {
                            variants.append(",").append(crEnt);
                        }
                        ++i;
                    }
                }
                jsonState = jsonState.replace("{type}", "Fasing").replace("{variants}", variants.toString());
            } else if (customblock instanceof CustomDoor) {
                jsonState = Util.instance.getDataFile("jbd.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            } else if (customblock instanceof CustomChest) {
                jsonState = Util.instance.getDataFile("jb" + (((CustomChest)customblock).isChest ? "h" : "c") + ".dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            }
            if (jsonState == null) {
                jsonState = Util.instance.getDataFile("jb.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
            }
            if (Util.instance.saveFile(blockstate, jsonState)) {
                LogWriter.debug("Create Default Blockstate for \"" + fileName + "\" block");
            }
        }
        File blockModel = new File(blockModelsDir, fileName + ".json");
        if (customblock instanceof CustomBlockSlab.CustomBlockSlabSingle) {
            blockModel = new File(blockModelsDir, "bottom_" + fileName + ".json");
        }
        if (!blockModel.exists()) {
            String jsonModel = null;
            if (customblock instanceof CustomBlockStairs) {
                jsonModel = Util.instance.getDataFile("bms.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                if (Util.instance.saveFile(blockModel, jsonModel.replace("{type}", ""))) {
                    LogWriter.debug("Create Default Stairs Block Model for \"" + fileName + "\" block");
                }
                if (Util.instance.saveFile(new File(blockModelsDir, fileName + "_inner.json"), jsonModel.replace("{type}", "inner_"))) {
                    LogWriter.debug("Create Default Inner Stairs Block Model for \"" + fileName + "\" block");
                }
                if (Util.instance.saveFile(new File(blockModelsDir, fileName + "_outer.json"), jsonModel.replace("{type}", "outer_"))) {
                    LogWriter.debug("Create Default Outer Stairs Block Model for \"" + fileName + "\" block");
                }
            } else if (customblock instanceof CustomBlockSlab) {
                if (customblock instanceof CustomBlockSlab.CustomBlockSlabSingle) {
                    jsonModel = Util.instance.getDataFile("bmss.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                    boolean bo = Util.instance.saveFile(blockModel, jsonModel.replace("{type}", "half"));
                    if (Util.instance.saveFile(new File(blockModelsDir, "upper_" + fileName + ".json"), jsonModel.replace("{type}", "upper")) && bo) {
                        LogWriter.debug("Create Default Slab Simple Block Model for \"" + fileName + "\" block");
                    }
                }
                if (customblock instanceof CustomBlockSlab.CustomBlockSlabDouble) {
                    jsonModel = "";
                    boolean bo = Util.instance.saveFile(blockModel, Util.instance.getDataFile("bmsd.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName.replace("double_", "")));
                    if (Util.instance.saveFile(new File(blockModelsDir, fileName + "_top.json"), Util.instance.getDataFile("bmsdt.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName.replace("double_", ""))) && bo) {
                        LogWriter.debug("Create Default Slab Blocks Model for \"" + fileName + "\" block");
                    }
                }
            } else if (customblock instanceof CustomDoor) {
                jsonModel = Util.instance.getDataFile("bmd.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                boolean bo = Util.instance.saveFile(new File(blockModelsDir, fileName + "_bottom.json"), jsonModel.replace("{type}", "door_bottom"));
                bo = Util.instance.saveFile(new File(blockModelsDir, fileName + "_bottom_rh.json"), jsonModel.replace("{type}", "door_bottom_rh")) && bo;
                bo = Util.instance.saveFile(new File(blockModelsDir, fileName + "_top.json"), jsonModel.replace("{type}", "door_top")) && bo;
                boolean bl = bo = Util.instance.saveFile(new File(blockModelsDir, fileName + "_top_rh.json"), jsonModel.replace("{type}", "door_top_rh")) && bo;
                if (Util.instance.saveFile(blockModel, jsonModel.replace("{type}", "door_bottom")) && bo) {
                    LogWriter.debug("Create Default Door Blocks Model for \"" + fileName + "\" block");
                }
            } else if (customblock instanceof CustomChest) {
                boolean isChest = ((CustomChest)customblock).isChest;
                if (isChest) {
                    jsonModel = Util.instance.getDataFile("bmh.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                    if (Util.instance.saveFile(blockModel, jsonModel)) {
                        LogWriter.debug("Create Default Chest Blocks Model for \"" + fileName + "\" block");
                    }
                } else {
                    jsonModel = Util.instance.getDataFile("bmc_m.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                    boolean bo = Util.instance.saveFile(new File(blockModelsDir, "obj/" + fileName + ".mtl"), jsonModel);
                    jsonModel = Util.instance.getDataFile("bmc_o.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName);
                    if (Util.instance.saveFile(new File(blockModelsDir, "obj/" + fileName + ".obj"), jsonModel) && bo) {
                        LogWriter.debug("Create Default Container Blocks Model for \"" + fileName + "\" block");
                    }
                }
            } else if (customblock instanceof CustomBlock && ((CustomBlock)customblock).hasProperty() && ((CustomBlock)customblock).FACING != null && Util.instance.saveFile(blockModel, jsonModel = Util.instance.getDataFile("bmp.dat").replace("{mod_id}", "customnpcs").replace("{name}", name))) {
                LogWriter.debug("Create Default Facing Block Model for \"" + fileName.toLowerCase() + "\" block");
            }
            if (jsonModel == null) {
                String texture = "blocks/" + name;
                if (customblock instanceof CustomBlockPortal) {
                    texture = "environment/custom_" + name + "_portal";
                }
                if (Util.instance.saveFile(blockModel, jsonModel = Util.instance.getDataFile("bm.dat").replace("{mod_id}", "customnpcs").replace("{name}", texture))) {
                    LogWriter.debug("Create Default Block Model for \"" + fileName.toLowerCase() + "\" block");
                }
            }
        }
        if (!(itemModel = new File(itemModelsDir, fileName.toLowerCase() + ".json")).exists() && Util.instance.saveFile(itemModel, Util.instance.getDataFile("bmi" + (customblock instanceof CustomDoor ? "d" : "") + ".dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName))) {
            LogWriter.debug("Create Default Block Item Model for \"" + name + "\" block");
        }
    }

    public void checkItemFiles(ICustomElement customitem) {
        String name = customitem.getCustomName().toLowerCase();
        String fileName = Objects.requireNonNull(((Item)customitem).getRegistryName()).func_110623_a().toLowerCase();
        NBTTagCompound nbtData = customitem.getCustomNbt().getMCNBT();
        File itemModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/item");
        if (!itemModelsDir.exists() && !itemModelsDir.mkdirs()) {
            return;
        }
        File itemModel = new File(itemModelsDir, fileName + ".json");
        if (customitem instanceof CustomArmor && (nbtData.func_150297_b("OBJData", 9) || nbtData.func_150297_b("OBJData", 10))) {
            File armorModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/armor");
            if (!armorModelsDir.exists() && !armorModelsDir.mkdirs()) {
                return;
            }
            File objModel = new File(armorModelsDir, name + ".obj");
            if (!objModel.exists()) {
                boolean bo = Util.instance.saveFile(objModel, Util.instance.getDataFile("am_o.dat").replace("{mod_id}", "customnpcs").replace("{name}", name));
                if (Util.instance.saveFile(new File(armorModelsDir, name + ".mtl"), Util.instance.getDataFile("am_m.dat").replace("{mod_id}", "customnpcs").replace("{name}", name)) && bo) {
                    LogWriter.debug("Create default OBJ armor \"" + fileName + "\"");
                }
            }
        }
        if (!itemModel.exists()) {
            String jsonModel = null;
            if (customitem instanceof CustomBow) {
                boolean bo = true;
                jsonModel = Util.instance.getDataFile("imbp.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName).replace("{name}", name);
                for (int i = 0; i < 3; ++i) {
                    File pulling = new File(itemModelsDir, fileName + "_pulling_" + i + ".json");
                    if (pulling.exists()) continue;
                    bo = Util.instance.saveFile(pulling, jsonModel.replace("{num}", "" + i)) && bo;
                }
                if (Util.instance.saveFile(itemModel, Util.instance.getDataFile("imb.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName).replace("{name}", name)) && bo) {
                    LogWriter.debug("Create Default Bow Item Model for \"" + name + "\" item");
                }
            } else if (customitem instanceof CustomShield) {
                jsonModel = Util.instance.getDataFile("imsb.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName).replace("{name}", name);
                boolean bo = true;
                File blocking = new File(itemModelsDir, fileName + "_blocking.json");
                if (!blocking.exists()) {
                    bo = Util.instance.saveFile(blocking, jsonModel);
                }
                if (Util.instance.saveFile(itemModel, Util.instance.getDataFile("ims.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName).replace("{name}", name)) && bo) {
                    LogWriter.debug("Create Default Bow Item Model for \"" + name + "\" item");
                }
            } else if (customitem instanceof CustomFishingRod) {
                jsonModel = Util.instance.getDataFile("imfc.dat").replace("{mod_id}", "customnpcs").replace("{name}", name);
                boolean bo = true;
                File cast = new File(itemModelsDir, fileName.toLowerCase() + "_cast.json");
                if (!cast.exists()) {
                    bo = Util.instance.saveFile(cast, jsonModel);
                }
                if (Util.instance.saveFile(itemModel, Util.instance.getDataFile("imf.dat").replace("{mod_id}", "customnpcs").replace("{file_name}", fileName).replace("{name}", name)) && bo) {
                    LogWriter.debug("Create Default Bow Item Model for \"" + name + "\" item");
                }
            } else if (customitem instanceof CustomWeapon) {
                jsonModel = Util.instance.getDataFile("imw.dat").replace("{mod_id}", "customnpcs").replace("{name}", name);
                if (Util.instance.saveFile(itemModel, jsonModel)) {
                    LogWriter.debug("Create Default Weapon Item Model for \"" + name + "\" item");
                }
            } else if (customitem instanceof CustomTool) {
                if (name.equals("axeexample")) {
                    File blockStatesDir;
                    File blockModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/block/obj");
                    if (!blockModelsDir.exists() && !blockModelsDir.mkdirs()) {
                        return;
                    }
                    File objModel = new File(blockModelsDir, name + ".obj");
                    boolean bo = true;
                    if (!objModel.exists()) {
                        File mtl;
                        File obj = new File(blockModelsDir, name + ".obj");
                        if (!obj.exists()) {
                            bo = Util.instance.saveFile(obj, Util.instance.getDataFile("ima_o.dat").replace("{name}", name));
                        }
                        if (!(mtl = new File(blockModelsDir, name + ".mtl")).exists()) {
                            boolean bl = bo = Util.instance.saveFile(mtl, Util.instance.getDataFile("ima_m.dat").replace("{mod_id}", "customnpcs").replace("{name}", name)) && bo;
                        }
                    }
                    if (!(blockStatesDir = new File(CustomNpcs.Dir, "assets/customnpcs/blockstates")).exists() && !blockStatesDir.mkdirs()) {
                        return;
                    }
                    File itemState = new File(blockStatesDir, "custom_" + name + ".json");
                    if (!itemState.exists()) {
                        boolean bl = bo = Util.instance.saveFile(itemState, Util.instance.getDataFile("imas.dat").replace("{mod_id}", "customnpcs").replace("{name}", name)) && bo;
                    }
                    if (Util.instance.saveFile(itemModel, jsonModel = Util.instance.getDataFile("ima.dat").replace("{mod_id}", "customnpcs").replace("{name}", name)) && bo) {
                        LogWriter.debug("Create Default Item Axe Model for \"" + name + "\" item");
                    }
                } else {
                    jsonModel = Util.instance.getDataFile("imt.dat").replace("{mod_id}", "customnpcs").replace("{name}", name);
                    if (Util.instance.saveFile(itemModel, jsonModel)) {
                        LogWriter.debug("Create Default Tool Item Model for \"" + name + "\" item");
                    }
                }
            } else if (customitem instanceof CustomArmor) {
                if (((CustomArmor)customitem).objModel == null) {
                    jsonModel = Util.instance.getDataFile("imr.dat").replace("{mod_id}", "customnpcs").replace("{name}", name + "_" + ((CustomArmor)customitem).field_77881_a.name().toLowerCase());
                    if (Util.instance.saveFile(itemModel, jsonModel)) {
                        LogWriter.debug("Create Default Armor Item Model for \"" + name + "\" item");
                    }
                } else {
                    jsonModel = Util.instance.getDataFile("imro.dat");
                    if (Util.instance.saveFile(itemModel, jsonModel)) {
                        LogWriter.debug("Create Default OBJ Armor Item Model for \"" + name + "\" item");
                    }
                }
            }
            if (jsonModel == null && Util.instance.saveFile(itemModel, Util.instance.getDataFile("im.dat").replace("{mod_id}", "customnpcs").replace("{name}", name))) {
                LogWriter.debug("Create Default Item Model for \"" + name + "\" item");
            }
        }
    }

    public void checkParticleFiles(ICustomElement customparticle) {
    }

    public void checkPotionFiles(ICustomElement custompotion) {
    }

    public void checkTexture(EntityNPCInterface npc) {
    }

    public void fixTileEntityData(TileEntity tile) {
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SET_TILE_DATA, tile.func_189515_b(new NBTTagCompound()));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Container getContainer(EnumGuiType gui, EntityPlayer player, int x, int y, int z, EntityNPCInterface npc) {
        switch (1.$SwitchMap$noppes$npcs$constants$EnumGuiType[gui.ordinal()]) {
            case 1: {
                return new ContainerAvailabilityInv(player);
            }
            case 2: {
                tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
                if (tile instanceof CustomTileEntityChest) {
                    return ((CustomTileEntityChest)tile).func_174876_a(player.field_71071_by, player);
                }
                return null;
            }
            case 3: {
                return new ContainerCustomChest(player, x);
            }
            case 4: {
                return new ContainerNPCInv(npc, player);
            }
            case 5: {
                return new ContainerNPCDropSetup(npc, player, x, y, z);
            }
            case 6: {
                loc = TransportController.getInstance().getTransport(x);
                if (loc == null) {
                    loc = new TransportLocation();
                    loc.id = x;
                    loc.category = TransportController.getInstance().categories.get(y);
                }
                if (player.field_70170_p.field_72995_K) {
                    loc = loc.copy();
                }
                return new ContainerNPCTransportSetup(player, loc, y);
            }
            case 7: {
                return new ContainerCarpentryBench(player.field_71071_by, player.field_70170_p, new BlockPos(x, y, z));
            }
            case 8: {
                bank = BankController.getInstance().getBank(x);
                if (bank == null) {
                    bank = new Bank();
                }
                return new ContainerNPCBank(player, bank, y, z);
            }
            case 9: 
            case 10: {
                return new ContainerNPCFollowerHire(npc, player, x);
            }
            case 11: {
                if (npc != null) {
                    return new ContainerNPCTrader(npc, player);
                }
                return new ContainerNPCTrader(x, player);
            }
            case 12: {
                return new ContainerNpcItemGiver(npc, player);
            }
            case 13: {
                mData = MarcetController.getInstance();
                marcet = (Marcet)mData.getMarcet(x);
                if (marcet == null) {
                    marcet = new Marcet(x);
                }
                if ((deal = (Deal)mData.getDeal(y)) == null) {
                    deal = new Deal(y);
                }
                return new ContainerNPCTraderSetup(marcet, deal, player);
            }
            case 14: {
                return new ContainerNPCFollowerSetup(npc, player);
            }
            case 15: {
                return new ContainerNpcQuestReward(player);
            }
            case 16: {
                return new ContainerNpcQuestTypeItem(player, x);
            }
            case 17: {
                return new ContainerNpcQuestRewardItem(x);
            }
            case 18: {
                return new ContainerManageRecipes(player);
            }
            case 19: {
                return new ContainerManageBanks(player);
            }
            case 20: {
                return new ContainerMerchantAdd(player, (IMerchant)ServerEventsHandler.Merchant, player.field_70170_p);
            }
            case 21: {
                return new ContainerMail(player, x == 1, y == 1);
            }
            case 22: {
                return new ContainerNPCCompanion(npc, player);
            }
            case 23: {
                return new ContainerCustomGui((IInventory)new InventoryBasic("", false, x));
            }
            case 24: {
                npc = PlayerData.get((EntityPlayer)player).editingNpc;
                deadInventory = null;
                name = player.func_70005_c_();
                if (npc == null || npc.func_70089_S()) ** GOTO lbl93
                dataInv = npc.inventory;
                deadInventory = dataInv.deadLoot;
                if (y <= -1 || dataInv.deadLoots == null || dataInv.deadLoots.isEmpty()) ** GOTO lbl91
                if (dataInv.deadLoots.size() != 1) ** GOTO lbl82
                for (EntityLivingBase e : dataInv.deadLoots.keySet()) {
                    if (e instanceof EntityPlayer || e.func_70005_c_().equals(npc.func_70005_c_())) continue;
                    deadInventory = (IInventory)dataInv.deadLoots.get(e);
                }
                y = 0;
                ** GOTO lbl93
lbl82:
                // 1 sources

                i = 0;
                for (EntityLivingBase e : dataInv.deadLoots.keySet()) {
                    if (i != y) {
                        ++i;
                        continue;
                    }
                    name = e.func_70005_c_();
                    deadInventory = (IInventory)dataInv.deadLoots.get(e);
                    ** GOTO lbl93
                }
                ** GOTO lbl93
lbl91:
                // 1 sources

                if (deadInventory == null && dataInv.deadLoots != null && dataInv.deadLoots.containsKey(player)) {
                    deadInventory = (IInventory)dataInv.deadLoots.get(player);
                }
lbl93:
                // 7 sources

                if (deadInventory == null) {
                    deadInventory = new InventoryBasic("NPC Loot", true, x);
                }
                return new ContainerDead(player, (IInventory)deadInventory, name, y);
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return new ContainerBuilderSettings(player, x, y);
            }
            case 30: {
                if (!(npc instanceof EntityCustomNpc)) break;
                return new ContainerLayer(player);
            }
        }
        return null;
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public PlayerData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return PlayerData.get(player);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID > EnumGuiType.values().length) {
            return null;
        }
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        EnumGuiType gui = EnumGuiType.values()[ID];
        return this.getContainer(gui, player, x, y, z, npc);
    }

    public void load() {
    }

    public void openGui(EntityNPCInterface npc, EnumGuiType gui) {
    }

    public void openGui(EntityNPCInterface npc, EnumGuiType gui, int x, int y, int z) {
    }

    public void openGui(EntityPlayer player, Object guiscreen) {
    }

    public void openGui(int i, int j, int k, EnumGuiType gui, EntityPlayer player) {
    }

    public void postload() {
    }

    public void preload() {
        CustomNpcs.Channel.register((Object)new PacketHandlerServer());
        CustomNpcs.ChannelPlayer.register((Object)new PacketHandlerPlayer());
    }

    public void reloadItemTextures() {
    }

    public void spawnParticle(EntityLivingBase player, String string, Object ... ob) {
    }

    public void spawnParticle(EnumParticleTypes type, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
    }

    public void updateGUI() {
    }

    public void updateKeys() {
    }

    public void applyRecipe(INpcRecipe recipe, boolean added) {
        if (recipe == null) {
            return;
        }
        if (!added || recipe.isKnown()) {
            List players = CustomNpcs.Server != null ? CustomNpcs.Server.func_184103_al().func_181057_v() : new ArrayList();
            for (EntityPlayerMP player : players) {
                RecipeBookServer book = player.func_192037_E();
                if (!added) {
                    book.func_193831_b((IRecipe)recipe);
                    continue;
                }
                book.func_194073_a((IRecipe)recipe);
            }
        }
    }

    public String getTranslateLanguage(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return "en";
        }
        String lang = EntityPlayerMPReflection.getLanguage((EntityPlayerMP)player);
        if (lang.contains("_")) {
            lang = lang.substring(0, lang.indexOf("_"));
        }
        return lang;
    }

    public void loadAnimationModel(AnimationConfig animation) {
    }

    public void updatePlayerPos() {
    }
}

